<?php
// Get the JSON payload
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Include the database configuration file
require 'dbconfig.php';



try {
    // Create a new PDO instance
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get the JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Log incoming data for debugging
    file_put_contents('debug.log', print_r($input, true), FILE_APPEND);

    // Check if activation details are provided
    if (isset($input) && is_array($input)) {
        // Prepare SQL statement to insert/update activation details
        foreach ($input as $activation) {
            $stmt = $pdo->prepare("
                INSERT INTO WindowsActivationStatus (ComputerName, Name, Description, LicenseStatus, ProductKey, ProductID, LastActivationTime, ActivationInterval, ExpirationTime, LastRunTime) 
                VALUES (:ComputerName, :Name, :Description, :LicenseStatus, :ProductKey, :ProductID, :LastActivationTime, :ActivationInterval, :ExpirationTime, :LastRunTime)
                ON DUPLICATE KEY UPDATE 
                    Description = :Description, 
                    LicenseStatus = :LicenseStatus, 
                    ProductKey = :ProductKey,
                    ProductID = :ProductID,
                    LastActivationTime = :LastActivationTime,
                    ActivationInterval = :ActivationInterval,
                    ExpirationTime = :ExpirationTime,
                    LastRunTime = :LastRunTime
            ");

            // Bind parameters
            $stmt->bindParam(':ComputerName', $activation['ComputerName']);
            $stmt->bindParam(':Name', $activation['Name']);
            $stmt->bindParam(':Description', $activation['Description']);
            $stmt->bindParam(':LicenseStatus', $activation['LicenseStatus']);
            $stmt->bindParam(':ProductKey', $activation['ProductKey']);
            $stmt->bindParam(':ProductID', $activation['ProductID']);
            $stmt->bindParam(':LastActivationTime', $activation['LastActivationTime']);
            $stmt->bindParam(':ActivationInterval', $activation['ActivationInterval']);
            $stmt->bindParam(':ExpirationTime', $activation['ExpirationTime']);
            $stmt->bindParam(':LastRunTime', $activation['LastRunTime']);

            // Execute the statement
            $stmt->execute();
        }

        echo json_encode(['Activation details updated successfully']);
    } else {
        echo json_encode(['No activation details provided']);
    }
} catch (PDOException $e) {
    // Log the error message
    file_put_contents('debug.log', 'Error: ' . $e->getMessage(), FILE_APPEND);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
