<?php
// Get the JSON payload
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Include the database configuration file
require 'dbconfig.php';

try {
    // Create a new PDO instance
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get the JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Prepare SQL statements to insert/update user account details
    foreach ($input['UserAccounts'] as $user) {
        $stmt = $pdo->prepare("
            INSERT INTO UserAccounts (ComputerName, AccountName, DomainName, Description, Status, SID, LastRunTime) 
            VALUES (:ComputerName, :AccountName, :DomainName, :Description, :Status, :SID, :LastRunTime)
            ON DUPLICATE KEY UPDATE 
                DomainName = :DomainName, 
                Description = :Description,
                Status = :Status,
                SID = :SID,
                LastRunTime = :LastRunTime
        ");

        // Bind parameters
        $stmt->bindParam(':ComputerName', $input['ComputerName']);
        $stmt->bindParam(':AccountName', $user['AccountName']);
        $stmt->bindParam(':DomainName', $user['DomainName']);
        $stmt->bindParam(':Description', $user['Description']);
        $stmt->bindParam(':Status', $user['Status']);
        $stmt->bindParam(':SID', $user['SID']);
        $stmt->bindParam(':LastRunTime', $input['LastRunTime']);

        // Execute the statement
        $stmt->execute();
    }

    echo json_encode(['User account details updated successfully']);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
