<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>

<?php
// Include the database configuration file
require 'dbconfig.php';

// Create a new PDO instance
try {
    $pdo = new PDO("mysql:host=$servername;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Could not connect to the database $dbname :" . $e->getMessage());
}

// Check if data is received
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the JSON input from the request
    $jsonData = file_get_contents('php://input');
    // Decode the JSON data into an associative array
    $userDetails = json_decode($jsonData, true);

    // Check if decoding was successful and if the array is not empty
    if (json_last_error() !== JSON_ERROR_NONE || empty($userDetails)) {
        echo json_encode(["status" => "error", "message" => "Invalid JSON data."]);
        exit;
    }

    // Prepare to insert or update user details
    foreach ($userDetails as $user) {
        $displayName = $user['DisplayName'] ?? '';
        $samAccountName = $user['SamAccountName'] ?? '';
        $userPrincipalName = $user['UserPrincipalName'] ?? '';
        $emailAddress = $user['EmailAddress'] ?? '';
        $phone = $user['Phone'] ?? '';
        $title = $user['Title'] ?? '';
        $department = $user['Department'] ?? '';

        // Check if the record exists
        $checkSql = "SELECT * FROM ad_users WHERE sam_account_name = :samAccountName";
        $checkStmt = $pdo->prepare($checkSql);
        $checkStmt->bindParam(':samAccountName', $samAccountName);
        $checkStmt->execute();

        // If the record exists, update it
        if ($checkStmt->rowCount() > 0) {
            $updateSql = "
                UPDATE ad_users 
                SET display_name = :displayName, 
                    user_principal_name = :userPrincipalName, 
                    email_address = :emailAddress, 
                    phone = :phone, 
                    title = :title, 
                    department = :department 
                WHERE sam_account_name = :samAccountName
            ";
            $updateStmt = $pdo->prepare($updateSql);
            $updateStmt->bindParam(':displayName', $displayName);
            $updateStmt->bindParam(':userPrincipalName', $userPrincipalName);
            $updateStmt->bindParam(':emailAddress', $emailAddress);
            $updateStmt->bindParam(':phone', $phone);
            $updateStmt->bindParam(':title', $title);
            $updateStmt->bindParam(':department', $department);
            $updateStmt->bindParam(':samAccountName', $samAccountName);

            try {
                $updateStmt->execute();
                echo json_encode(['status' => 'success', 'message' => 'User data updated successfully.']);
            } catch (PDOException $e) {
                echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
            }
        } else {
            // Record does not exist, insert a new one
            $insertSql = "
                INSERT INTO ad_users (display_name, sam_account_name, user_principal_name, email_address, phone, title, department)
                VALUES (:displayName, :samAccountName, :userPrincipalName, :emailAddress, :phone, :title, :department)
            ";
            $insertStmt = $pdo->prepare($insertSql);
            $insertStmt->bindParam(':displayName', $displayName);
            $insertStmt->bindParam(':samAccountName', $samAccountName);
            $insertStmt->bindParam(':userPrincipalName', $userPrincipalName);
            $insertStmt->bindParam(':emailAddress', $emailAddress);
            $insertStmt->bindParam(':phone', $phone);
            $insertStmt->bindParam(':title', $title);
            $insertStmt->bindParam(':department', $department);

            try {
                $insertStmt->execute();
                echo json_encode(['status' => 'success', 'message' => 'Data saved or updated successfully']);
            } catch (PDOException $e) {
                echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
            }
        }
    }
} else {
    // Return a response if the request method is not POST
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}

// Close the database connection
$pdo = null;
?>
