<?php
// Get the JSON payload
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Include the database configuration file
require 'dbconfig.php';



try {
    // Create a new PDO instance
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get the JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Prepare SQL statements to insert/update RAM details
    foreach ($input['RAMModules'] as $module) {
        $stmt = $pdo->prepare("
            INSERT INTO ram_details (ComputerName, CapacityGB, Manufacturer, SpeedMHz, SerialNumber, PartNumber, LastRunTime) 
            VALUES (:ComputerName, :CapacityGB, :Manufacturer, :SpeedMHz, :SerialNumber, :PartNumber, :LastRunTime)
            ON DUPLICATE KEY UPDATE 
                CapacityGB = :CapacityGB, 
                Manufacturer = :Manufacturer, 
                SpeedMHz = :SpeedMHz,
                PartNumber = :PartNumber,
                LastRunTime = :LastRunTime
        ");

        // Bind parameters
        $stmt->bindParam(':ComputerName', $input['ComputerName']);
        $stmt->bindParam(':CapacityGB', $module['CapacityGB']);
        $stmt->bindParam(':Manufacturer', $module['Manufacturer']);
        $stmt->bindParam(':SpeedMHz', $module['SpeedMHz']);
        $stmt->bindParam(':SerialNumber', $module['SerialNumber']);
        $stmt->bindParam(':PartNumber', $module['PartNumber']);
        $stmt->bindParam(':LastRunTime', $input['LastRunTime']);

        // Execute the statement
        $stmt->execute();
    }

    echo json_encode(['Data saved or updated successfully']);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
