<?php
// Get the JSON payload
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Include the database configuration file
require 'dbconfig.php';

try {
    // Create a new PDO instance
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get the JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Check if input is valid
    if (!isset($input) || empty($input)) {
        echo json_encode(['success' => false, 'message' => 'No data received']);
        exit;
    }

    // Prepare SQL statements to insert/update patch details
    foreach ($input as $patch) {
        $stmt = $pdo->prepare("
            INSERT INTO patch_update_list (ComputerName, PatchID, Description, InstalledOn) 
            VALUES (:ComputerName, :PatchID, :Description, :InstalledOn)
            ON DUPLICATE KEY UPDATE 
                Description = :Description, 
                InstalledOn = :InstalledOn
        ");

        // Bind parameters
        $stmt->bindParam(':ComputerName', $patch['ComputerName']);
        $stmt->bindParam(':PatchID', $patch['PatchID']);
        $stmt->bindParam(':Description', $patch['Description']);
        $stmt->bindParam(':InstalledOn', $patch['InstalledOn']);

        // Execute the statement
        $stmt->execute();
    }

    echo json_encode(['Patch details updated successfully']);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
