<?php
// Include the database configuration file
require 'dbconfig.php';




// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get the JSON data from the POST request
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Validate received data
if (isset($data['ComputerName']) && isset($data['Partitions']) && is_array($data['Partitions'])) {
    $computerName = $data['ComputerName'];
    $lastRunTime = $data['LastRunTime'];

    // Loop through each partition detail
    foreach ($data['Partitions'] as $partition) {
        $deviceID = $partition['DeviceID'];
        $volumeName = $partition['VolumeName'];
        $fileSystem = $partition['FileSystem'];
        $freeSpaceGB = $partition['FreeSpaceGB'];
        $totalSizeGB = $partition['TotalSizeGB'];

        // Check if the combination of ComputerName and DeviceID already exists in the database
        $checkSql = "SELECT id FROM partition_details WHERE ComputerName = ? AND DeviceID = ?";
        $checkStmt = $conn->prepare($checkSql);
        $checkStmt->bind_param("ss", $computerName, $deviceID);
        $checkStmt->execute();
        $result = $checkStmt->get_result();

        if ($result->num_rows > 0) {
            // If the combination exists, perform an update
            $sql = "UPDATE partition_details SET 
                        VolumeName = ?, 
                        FileSystem = ?, 
                        FreeSpaceGB = ?, 
                        TotalSizeGB = ?, 
                        LastRunTime = ? 
                    WHERE ComputerName = ? AND DeviceID = ?";
            $stmt = $conn->prepare($sql);
            
            if ($stmt === false) {
                die("Error preparing statement: " . $conn->error);
            }

            // Bind parameters and execute the SQL statement for updating
            $stmt->bind_param("ssddsss", $volumeName, $fileSystem, $freeSpaceGB, $totalSizeGB, $lastRunTime, $computerName, $deviceID);

            if (!$stmt->execute()) {
                echo "Error updating data: " . $stmt->error;
            }
        } else {
            // If the combination does not exist, perform an insert
            $sql = "INSERT INTO partition_details (ComputerName, DeviceID, VolumeName, FileSystem, FreeSpaceGB, TotalSizeGB, LastRunTime)
                    VALUES (?, ?, ?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            
            if ($stmt === false) {
                die("Error preparing statement: " . $conn->error);
            }

            // Bind parameters and execute the SQL statement for inserting
            $stmt->bind_param("sssdsss", $computerName, $deviceID, $volumeName, $fileSystem, $freeSpaceGB, $totalSizeGB, $lastRunTime);

            if (!$stmt->execute()) {
                echo "Error inserting data: " . $stmt->error;
            }
        }
    }

    echo "Data saved or updated successfully";
    
    // Close the check statement
    $checkStmt->close();
} else {
    echo "Invalid data received.";
}

// Close the statement and connection
$stmt->close();
$conn->close();
?>
