<?php
// Include the database configuration file
require 'dbconfig.php';

// Create a connection to the MySQL database
$conn = new mysqli($host, $username, $password, $dbname);

// Check for connection errors
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Set the content type to application/json
header('Content-Type: application/json');

// Get the JSON data from the request body
$input = file_get_contents('php://input');

// Decode the JSON data into a PHP array
$data = json_decode($input, true);

// Check if data is available
if (!isset($data['ComputerName']) || !isset($data['Monitors'])) {
    echo json_encode(["error" => "Invalid data format"]);
    exit;
}

$computerName = $conn->real_escape_string($data['ComputerName']);
$lastRunTime = $conn->real_escape_string($data['LastRunTime']);

// Loop through each monitor and check if the combination of computer_name and serial_number already exists
foreach ($data['Monitors'] as $monitor) {
    $manufacturer = $conn->real_escape_string($monitor['Manufacturer']);
    $model = $conn->real_escape_string($monitor['Model']);
    $serialNumber = $conn->real_escape_string($monitor['SerialNumber']);

    // Check if the combination of computer_name and serial_number exists in the database
    $checkQuery = "SELECT * FROM monitors WHERE computer_name = '$computerName' AND serial_number = '$serialNumber'";
    $result = $conn->query($checkQuery);

    if ($result->num_rows > 0) {
        // If both computer_name and serial_number exist, update the monitor details
        $sql = "UPDATE monitors SET 
                manufacturer = '$manufacturer',
                model = '$model',
                last_run_time = '$lastRunTime'
                WHERE computer_name = '$computerName' AND serial_number = '$serialNumber'";
        
        if ($conn->query($sql) === TRUE) {
            $response = ["Data updated successfully"];
        } else {
            $response = ["status" => "error", "message" => "Error updating data: " . $conn->error];
        }
    } else {
        // If the combination does not exist, insert new monitor details
        $sql = "INSERT INTO monitors (computer_name, manufacturer, model, serial_number, last_run_time) 
                VALUES ('$computerName', '$manufacturer', '$model', '$serialNumber', '$lastRunTime')";
        
        if ($conn->query($sql) === TRUE) {
            $response = ["Data saved or updated successfully"];
        } else {
            $response = ["status" => "error", "message" => "Error inserting data: " . $conn->error];
        }
    }
}

// Close the database connection
$conn->close();

// Return the response as JSON
echo json_encode($response);
?>
