<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>

<?php
// Include the database configuration file
require 'dbconfig.php';

// Create a new PDO instance
try {
    $pdo = new PDO("mysql:host=$servername;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Could not connect to the database $dbname :" . $e->getMessage());
}

// Check if data is received
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve the data
    $displayName = $_POST['DisplayName'] ?? '';
    $userPrincipalName = $_POST['UserPrincipalName'] ?? '';
    $license = $_POST['License'] ?? '';

    // Prepare a statement to check if the record exists
    $checkSql = "SELECT * FROM microsoft_user_licenses WHERE user_principal_name = :userPrincipalName AND license = :license";
    $checkStmt = $pdo->prepare($checkSql);
    $checkStmt->bindParam(':userPrincipalName', $userPrincipalName);
    $checkStmt->bindParam(':license', $license);
    $checkStmt->execute();

    // Check if the record exists
    if ($checkStmt->rowCount() > 0) {
        // Record exists, so we update it
        $updateSql = "UPDATE microsoft_user_licenses SET display_name = :displayName WHERE user_principal_name = :userPrincipalName AND license = :license";
        $updateStmt = $pdo->prepare($updateSql);
        $updateStmt->bindParam(':displayName', $displayName);
        $updateStmt->bindParam(':userPrincipalName', $userPrincipalName);
        $updateStmt->bindParam(':license', $license);
        
        try {
            $updateStmt->execute();
            echo json_encode(['Data updated successfully']);
        } catch (PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
    } else {
        // Record does not exist, so we insert it
        $insertSql = "INSERT INTO microsoft_user_licenses (display_name, user_principal_name, license) VALUES (:displayName, :userPrincipalName, :license)";
        $insertStmt = $pdo->prepare($insertSql);

        try {
            $insertStmt->bindParam(':displayName', $displayName);
            $insertStmt->bindParam(':userPrincipalName', $userPrincipalName);
            $insertStmt->bindParam(':license', $license);
            $insertStmt->execute();
            echo json_encode(['Data saved successfully']);
        } catch (PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }
} else {
    // Return a response if the request method is not POST
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}

// Close the database connection
$pdo = null;
?>
