<?php
// Get the JSON payload
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Include the database configuration file
require 'dbconfig.php';


// Create a new PDO instance to connect to the database
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    // Set the PDO error mode to exception
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

// Get the raw POST data
$postData = file_get_contents('php://input');

// Decode the JSON data into a PHP array
$data = json_decode($postData, true);

// Check if data is valid
if (is_array($data)) {
    // Prepare an SQL statement to insert or update the license details
    $sql = "INSERT INTO microsoft_license_details (sku_id, total_licenses, assigned_licenses, available_licenses) 
            VALUES (:sku_id, :total_licenses, :assigned_licenses, :available_licenses)
            ON DUPLICATE KEY UPDATE 
                total_licenses = :total_licenses,
                assigned_licenses = :assigned_licenses,
                available_licenses = :available_licenses";

    $stmt = $pdo->prepare($sql);

    // Loop through each license entry in the received data
    foreach ($data as $license) {
        // Bind parameters to the SQL statement
        $stmt->bindParam(':sku_id', $license['SkuId']);
        $stmt->bindParam(':total_licenses', $license['TotalLicenses']);
        $stmt->bindParam(':assigned_licenses', $license['AssignedLicenses']);
        $stmt->bindParam(':available_licenses', $license['AvailableLicenses']);

        // Execute the statement
        $stmt->execute();
    }

    // Send success response
    $response = ['success' => true, 'message' => 'License details saved or updated successfully.'];
} else {
    // Send error response if data is invalid
    $response = ['success' => false, 'message' => 'Invalid data format.'];
}

// Send the response back to the PowerShell script
header('Content-Type: application/json');
echo json_encode($response);
?>
