<?php
// Include the database configuration file
require 'dbconfig.php';


// Create connection
$conn = new mysqli($host, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Function to convert date to 'YYYY-MM-DD' format
function convertToDate($dateString) {
    // Attempt to create a DateTime object from the string
    $date = DateTime::createFromFormat('Ymd', $dateString);  // Expecting format like '20210915'
    
    if ($date) {
        return $date->format('Y-m-d');
    } else {
        return null;  // If the date format is not valid, return null
    }
}

// Get the JSON data from the POST request
$jsonData = file_get_contents('php://input');
$softwareList = json_decode($jsonData, true);  // Convert JSON to an array

// Prepare and bind the MySQL insert statement with ON DUPLICATE KEY UPDATE
$stmt = $conn->prepare("
    INSERT INTO Installed_Software_Details (ComputerName, Name, Version, Publisher, InstallDate)
    VALUES (?, ?, ?, ?, ?)
    ON DUPLICATE KEY UPDATE
        Version = VALUES(Version),
        Publisher = VALUES(Publisher),
        InstallDate = VALUES(InstallDate)
");

// Loop through each software and execute the insert/update
foreach ($softwareList as $software) {
    // Convert InstallDate to MySQL-friendly format
    $installDate = convertToDate($software['InstallDate']);
    
    // Bind and execute statement
    $stmt->bind_param("sssss", $software['ComputerName'], $software['Name'], $software['Version'], $software['Publisher'], $installDate);
    
    if (!$stmt->execute()) {
        // Log error if execution fails
        error_log("Execution failed: " . $stmt->error);
    }
}

// Close the statement and connection
$stmt->close();
$conn->close();

// Return a success message
echo json_encode(["Data inserted/updated successfully"]);
?>
