<?php
// Get the JSON payload
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Include the database configuration file
require 'dbconfig.php';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get the JSON data from the POST request
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Validate received data
if (isset($data['ComputerName']) && isset($data['HardDisks']) && is_array($data['HardDisks'])) {
    $computerName = $data['ComputerName'];
    $lastRunTime = $data['LastRunTime'];

    // Loop through each hard disk detail
    foreach ($data['HardDisks'] as $disk) {
        $manufacturer = $disk['Manufacturer'];
        $model = $disk['Model'];
        $serialNumber = $disk['SerialNumber'];
        $sizeGB = $disk['SizeGB'];

        // Check if the combination of ComputerName and Model already exists in the database
        $checkSql = "SELECT id FROM harddisk_details WHERE ComputerName = ? AND Model = ?";
        $checkStmt = $conn->prepare($checkSql);
        $checkStmt->bind_param("ss", $computerName, $model);
        $checkStmt->execute();
        $result = $checkStmt->get_result();

        if ($result->num_rows > 0) {
            // If the combination exists, update the record
            $sql = "UPDATE harddisk_details SET 
                        Manufacturer = ?, 
                        SerialNumber = ?, 
                        SizeGB = ?, 
                        LastRunTime = ? 
                    WHERE ComputerName = ? AND Model = ?";
            $stmt = $conn->prepare($sql);
            
            if ($stmt === false) {
                die("Error preparing statement: " . $conn->error);
            }

            // Bind parameters and execute the SQL statement for updating
            $stmt->bind_param("ssdsss", $manufacturer, $serialNumber, $sizeGB, $lastRunTime, $computerName, $model);

            if (!$stmt->execute()) {
                echo "Error updating data: " . $stmt->error;
            }
        } else {
            // If the combination does not exist, insert a new record
            $sql = "INSERT INTO harddisk_details (ComputerName, Manufacturer, Model, SerialNumber, SizeGB, LastRunTime)
                    VALUES (?, ?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            
            if ($stmt === false) {
                die("Error preparing statement: " . $conn->error);
            }

            // Bind parameters and execute the SQL statement for inserting
            $stmt->bind_param("sssdss", $computerName, $manufacturer, $model, $serialNumber, $sizeGB, $lastRunTime);

            if (!$stmt->execute()) {
                echo "Error inserting data: " . $stmt->error;
            }
        }

        // Close the statement after each execution to free resources
        $stmt->close();
    }

    echo "Data saved or updated successfully";
    // Close the check statement
    $checkStmt->close();
} else {
    echo "Invalid data received.";
}

// Close the database connection
$conn->close();
?>
