<?php
// Get the JSON payload
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Include the database configuration file
require 'dbconfig.php';


try {
    // Create a new PDO instance
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get the JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Check if the computer already exists
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM cpu_details WHERE ComputerName = :ComputerName");
    $stmt->bindParam(':ComputerName', $input['ComputerName']);
    $stmt->execute();
    $exists = $stmt->fetchColumn() > 0;

    if ($exists) {
        // Update existing record
        $updateStmt = $pdo->prepare("
            UPDATE cpu_details 
            SET CPUManufacturer = :CPUManufacturer,
                CPUModel = :CPUModel,
                CPUSerialNumber = :CPUSerialNumber,
                CPUArchitecture = :CPUArchitecture,
                NumberOfCores = :NumberOfCores,
                NumberOfLogicalProcessors = :NumberOfLogicalProcessors,
                MaxClockSpeed = :MaxClockSpeed,
                CurrentClockSpeed = :CurrentClockSpeed,
                L2CacheSize = :L2CacheSize,
                L3CacheSize = :L3CacheSize
            WHERE ComputerName = :ComputerName
        ");

        // Bind parameters
        $updateStmt->bindParam(':ComputerName', $input['ComputerName']);
        $updateStmt->bindParam(':CPUManufacturer', $input['CPUManufacturer']);
        $updateStmt->bindParam(':CPUModel', $input['CPUModel']);
        $updateStmt->bindParam(':CPUSerialNumber', $input['CPUSerialNumber']);
        $updateStmt->bindParam(':CPUArchitecture', $input['CPUArchitecture']);
        $updateStmt->bindParam(':NumberOfCores', $input['NumberOfCores']);
        $updateStmt->bindParam(':NumberOfLogicalProcessors', $input['NumberOfLogicalProcessors']);
        
        // Modify MaxClockSpeed to include units, e.g., "3.5 GHz"
        $maxClockSpeed = isset($input['MaxClockSpeed']) ? $input['MaxClockSpeed'] . ' GHz' : null;
        $updateStmt->bindParam(':MaxClockSpeed', $maxClockSpeed);

        $updateStmt->bindParam(':CurrentClockSpeed', $input['CurrentClockSpeed']);
        $updateStmt->bindParam(':L2CacheSize', $input['L2CacheSize']);
        $updateStmt->bindParam(':L3CacheSize', $input['L3CacheSize']);

        // Execute the update
        $updateStmt->execute();
        echo json_encode(['success' => true, 'message' => 'Data updated successfully']);
    } else {
        // Insert new record
        $insertStmt = $pdo->prepare("
            INSERT INTO cpu_details (ComputerName, CPUManufacturer, CPUModel, CPUSerialNumber, CPUArchitecture, NumberOfCores, NumberOfLogicalProcessors, MaxClockSpeed, CurrentClockSpeed, L2CacheSize, L3CacheSize) 
            VALUES (:ComputerName, :CPUManufacturer, :CPUModel, :CPUSerialNumber, :CPUArchitecture, :NumberOfCores, :NumberOfLogicalProcessors, :MaxClockSpeed, :CurrentClockSpeed, :L2CacheSize, :L3CacheSize)
        ");

        // Bind parameters
        $insertStmt->bindParam(':ComputerName', $input['ComputerName']);
        $insertStmt->bindParam(':CPUManufacturer', $input['CPUManufacturer']);
        $insertStmt->bindParam(':CPUModel', $input['CPUModel']);
        $insertStmt->bindParam(':CPUSerialNumber', $input['CPUSerialNumber']);
        $insertStmt->bindParam(':CPUArchitecture', $input['CPUArchitecture']);
        $insertStmt->bindParam(':NumberOfCores', $input['NumberOfCores']);
        $insertStmt->bindParam(':NumberOfLogicalProcessors', $input['NumberOfLogicalProcessors']);
        
        // Modify MaxClockSpeed to include units, e.g., "3.5 GHz"
        $maxClockSpeedInsert = isset($input['MaxClockSpeed']) ? $input['MaxClockSpeed'] . ' GHz' : null;
        $insertStmt->bindParam(':MaxClockSpeed', $maxClockSpeedInsert);

        $insertStmt->bindParam(':CurrentClockSpeed', $input['CurrentClockSpeed']);
        $insertStmt->bindParam(':L2CacheSize', $input['L2CacheSize']);
        $insertStmt->bindParam(':L3CacheSize', $input['L3CacheSize']);

        // Execute the insert
        $insertStmt->execute();
        echo json_encode(['success' => true, 'message' => 'Data saved or updated successfully']);
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
