<?php
// Get the JSON payload
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Include the database configuration file
require 'dbconfig.php';


// Create a connection to the MySQL database
$conn = new mysqli($servername, $username, $password, $dbname);

// Check the connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get the POST data (JSON)
$data = file_get_contents('php://input');
$json = json_decode($data, true);

// Extract computer name and chassis types from the received JSON
$computerName = $json['ComputerName'];
$chassisTypes = $json['ChassisTypes'];

// Map the chassis type to a description (adjust this as needed)
$chassisDescriptions = [
    1 => 'Other', 2 => 'Unknown', 3 => 'Desktop', 4 => 'Low Profile Desktop',
    5 => 'Pizza Box', 6 => 'Mini Tower', 7 => 'Tower', 8 => 'Portable',
    9 => 'Laptop', 10 => 'Notebook', 11 => 'Hand Held', 12 => 'Docking Station',
    13 => 'All in One', 14 => 'Sub Notebook', 15 => 'Space-Saving', 
    16 => 'Lunch Box', 17 => 'Main System Chassis', 18 => 'Expansion Chassis', 
    19 => 'SubChassis', 20 => 'Bus Expansion Chassis', 21 => 'Peripheral Chassis', 
    22 => 'Storage Chassis', 23 => 'Rack Mount Chassis', 24 => 'Sealed-Case PC', 
    25 => 'Multi-System Chassis', 26 => 'Compact PCI', 27 => 'Advanced TCA', 
    28 => 'Blade', 29 => 'Blade Enclosure', 30 => 'Tablet', 31 => 'Convertible', 
    32 => 'Detachable', 33 => 'IoT Gateway', 34 => 'Embedded PC', 35 => 'Mini PC', 
    36 => 'Stick PC', 39 => 'Server'
];

// Loop through the chassis types and insert/update them in the database
foreach ($chassisTypes as $chassisType) {
    $chassisDescription = isset($chassisDescriptions[$chassisType]) ? $chassisDescriptions[$chassisType] : 'Unknown';

    // Check if the computer name and chassis description already exist in the database
    $checkSql = "SELECT id FROM ChassisTypes WHERE ComputerName = '$computerName' AND chassis_description = '$chassisDescription'";
    $result = $conn->query($checkSql);

    if ($result->num_rows > 0) {
        // Record exists, so update it
        $row = $result->fetch_assoc();
        $updateSql = "UPDATE ChassisTypes 
                      SET chassis_type = $chassisType, timestamp = CURRENT_TIMESTAMP 
                      WHERE id = " . $row['id'];
        
        if ($conn->query($updateSql) === TRUE) {
            echo "ChassisType for $computerName updated successfully.\n";
        } else {
            echo "Error updating record: " . $conn->error . "\n";
        }
    } else {
        // Record doesn't exist, so insert a new one
        $insertSql = "INSERT INTO ChassisTypes (ComputerName, chassis_type, chassis_description) 
                      VALUES ('$computerName', $chassisType, '$chassisDescription')";
        
        if ($conn->query($insertSql) === TRUE) {
            echo "ChassisType for $computerName inserted successfully.\n";
        } else {
            echo "Error: " . $insertSql . "\n" . $conn->error;
        }
    }
}

// Close the connection
$conn->close();
?>
