<?php include 'layouts/session.php'; ?>
<?php include 'layouts/main.php'; ?>

    <head>

        <?php includeFileWithVariables('layouts/title-meta.php', array('title' => 'Application')); ?>

        <!-- Sweet Alert css-->
        <link href="assets/libs/sweetalert2/sweetalert2.min.css" rel="stylesheet" type="text/css" />

        <?php include 'layouts/head-css.php'; ?>

    </head>

    <body>

        <!-- Begin page -->
        <div id="layout-wrapper">

            <?php include 'layouts/menu.php'; ?>

            <!-- ============================================================== -->
            <!-- Start right Content here -->
            <!-- ============================================================== -->
            <div class="main-content">

                <div class="page-content">
                    <div class="container-fluid">

                        <?php includeFileWithVariables('layouts/page-title.php', array('pagetitle' => 'Jobs', 'title' => 'Application')); ?>

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card" id="applicationList">
                                    <div class="card-header  border-0">
                                        <div class="d-md-flex align-items-center">
                                            <h5 class="card-title mb-3 mb-md-0 flex-grow-1">Job Application</h5>
                                            <div class="flex-shrink-0">
                                                <div class="d-flex gap-1 flex-wrap">
                                                    <button type="button" class="btn btn-primary add-btn" data-bs-toggle="modal" id="create-btn" data-bs-target="#showModal"><i class="ri-add-line align-bottom me-1"></i> Create Application</button>
                                                    <button type="button" class="btn btn-success"><i class="ri-file-download-line align-bottom me-1"></i> Import</button>
                                                    <button class="btn btn-soft-danger" id="remove-actions" onClick="deleteMultiple()"><i class="ri-delete-bin-2-line"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body border border-dashed border-end-0 border-start-0">
                                        <form>
                                            <div class="row g-3">
                                                <div class="col-xxl-5 col-sm-6">
                                                    <div class="search-box">
                                                        <input type="text" class="form-control search" placeholder="Search for application ID, company, designation status or something...">
                                                        <i class="ri-search-line search-icon"></i>
                                                    </div>
                                                </div>
                                                <!--end col-->
                                                <div class="col-xxl-2 col-sm-6">
                                                    <div>
                                                        <input type="text" class="form-control" data-provider="flatpickr" data-date-format="d M, Y" data-range-date="true" id="demo-datepicker" placeholder="Select date">
                                                    </div>
                                                </div>
                                                <!--end col-->
                                                <div class="col-xxl-2 col-sm-4">
                                                    <div>
                                                        <select class="form-control" data-choices data-choices-search-false name="choices-single-default" id="idStatus">
                                                            <option value="">Status</option>
                                                            <option value="all" selected>All</option>
                                                            <option value="Approved">Approved</option>
                                                            <option value="New">New</option>
                                                            <option value="Pending">Pending</option>
                                                            <option value="Rejected">Rejected</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <!--end col-->
                                                <div class="col-xxl-2 col-sm-4">
                                                    <div>
                                                        <select class="form-control" data-choices data-choices-search-false name="choices-single-default" id="idType">
                                                            <option value="">Select Type</option>
                                                            <option value="all" selected>All</option>
                                                            <option value="Full Time">Full Time</option>
                                                            <option value="Part Time">Part Time</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <!--end col-->
                                                <div class="col-xxl-1 col-sm-4">
                                                    <div>
                                                        <button type="button" class="btn btn-danger w-100" onclick="filterData();"> <i class="ri-equalizer-fill me-1 align-bottom"></i>
                                                            Filters
                                                        </button>
                                                    </div>
                                                </div>
                                                <!--end col-->
                                            </div>
                                            <!--end row-->
                                        </form>
                                    </div>
                                    <div class="card-body pt-0">
                                        <div>
                                            <ul class="nav nav-tabs nav-tabs-custom nav-success mb-3" role="tablist">
                                                <li class="nav-item">
                                                    <a class="nav-link active All py-3" data-bs-toggle="tab" id="All" href="#" role="tab" aria-selected="true">
                                                        All Application
                                                    </a>
                                                </li>
                                                <li class="nav-item">
                                                    <a class="nav-link py-3 New" data-bs-toggle="tab" id="New" href="#" role="tab" aria-selected="false">
                                                        New
                                                    </a>
                                                </li>
                                                <li class="nav-item">
                                                    <a class="nav-link py-3 Pending" data-bs-toggle="tab" id="Pending" href="#" role="tab" aria-selected="false">
                                                        Pending <span class="badge bg-danger align-middle ms-1">2</span>
                                                    </a>
                                                </li>
                                                <li class="nav-item">
                                                    <a class="nav-link py-3 Approved" data-bs-toggle="tab" id="Approved" href="#" role="tab" aria-selected="false">
                                                        Approved
                                                    </a>
                                                </li>
                                                <li class="nav-item">
                                                    <a class="nav-link py-3 Rejected" data-bs-toggle="tab" id="Rejected" href="#" role="tab" aria-selected="false">
                                                        Rejected
                                                    </a>
                                                </li>
                                            </ul>

                                            <div class="table-responsive table-card mb-1">
                                                <table class="table table-nowrap align-middle" id="jobListTable">
                                                    <thead class="text-muted table-light">
                                                        <tr class="text-uppercase">
                                                            <th scope="col" style="width: 25px;">
                                                                <div class="form-check">
                                                                    <input class="form-check-input" type="checkbox" id="checkAll" value="option">
                                                                </div>
                                                            </th>
                                                            <th class="sort" data-sort="id" style="width: 140px;">Application ID</th>
                                                            <th class="sort" data-sort="company">Company Name</th>
                                                            <th class="sort" data-sort="designation">Designation</th>
                                                            <th class="sort" data-sort="date">Apply Date</th>
                                                            <th class="sort" data-sort="contacts">Contacts</th>
                                                            <th class="sort" data-sort="type">Type</th>
                                                            <th class="sort" data-sort="status">Status</th>
                                                            <th class="sort" data-sort="city">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="list form-check-all">
                                                        <tr>
                                                            <th scope="row">
                                                                <div class="form-check">
                                                                    <input class="form-check-input" type="checkbox" name="checkAll" value="option1">
                                                                </div>
                                                            </th>
                                                            <td class="id"><a href="#" class="fw-semibold link-primary">#VZ001</a></td>
                                                            <td class="company">
                                                                <div class="d-flex align-items-center">
                                                                    <div class="flex-shrink-0">
                                                                        <img src="assets/images/brands/slack.png" alt="" class="avatar-xxs rounded-circle image_src object-fit-cover">
                                                                    </div>
                                                                    <div class="flex-grow-1 ms-2">Syntyce Solutions</div>
                                                                </div>
                                                            </td>
                                                            <td class="designation">Web Designer</td>
                                                            <td class="date">30 Sep,2022</td>
                                                            <td class="contacts">785-685-4616</td>
                                                            <td class="type">Full Time</td>
                                                            <td class="status"><span class="badge bg-danger-subtle text-danger text-uppercase">Rejected</span>
                                                            </td>
                                                            <td>
                                                                <ul class="list-inline hstack gap-2 mb-0">
                                                                    <li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="View">
                                                                        <a href="apps-job-details.php" class="text-primary d-inline-block">
                                                                            <i class="ri-eye-fill fs-16"></i>
                                                                        </a>
                                                                    </li>
                                                                    <li class="list-inline-item edit" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Edit">
                                                                        <a href="#showModal" data-bs-toggle="modal" class="text-primary d-inline-block edit-item-btn">
                                                                            <i class="ri-pencil-fill fs-16"></i>
                                                                        </a>
                                                                    </li>
                                                                    <li class="list-inline-item" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" title="Remove">
                                                                        <a class="text-danger d-inline-block remove-item-btn" data-bs-toggle="modal" href="#deleteOrder">
                                                                            <i class="ri-delete-bin-5-fill fs-16"></i>
                                                                        </a>
                                                                    </li>
                                                                </ul>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                                <div class="noresult" style="display: none">
                                                    <div class="text-center">
                                                        <lord-icon src="https://cdn.lordicon.com/msoeawqm.json" trigger="loop" colors="primary:#405189,secondary:#0ab39c" style="width:75px;height:75px"></lord-icon>
                                                        <h5 class="mt-2">Sorry! No Result Found</h5>
                                                        <p class="text-muted">We've searched more than 150+ result We did not find jobs for you search.</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="d-flex justify-content-end">
                                                <div class="pagination-wrap hstack gap-2">
                                                    <a class="page-item pagination-prev disabled" href="#">
                                                        Previous
                                                    </a>
                                                    <ul class="pagination listjs-pagination mb-0"></ul>
                                                    <a class="page-item pagination-next" href="#">
                                                        Next
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal fade" id="showModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header bg-light p-3">
                                                        <h5 class="modal-title" id="exampleModalLabel">&nbsp;</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
                                                    </div>
                                                    <form class="tablelist-form" autocomplete="off">
                                                        <div class="modal-body">
                                                            <input type="hidden" id="id-field" />
    
                                                            <div class="mb-3 d-none" id="modal-id">
                                                                <label for="applicationId" class="form-label">ID</label>
                                                                <input type="text" id="applicationId" class="form-control" placeholder="ID" readonly />
                                                            </div>
    
                                                            <div class="text-center">
                                                                <div class="position-relative d-inline-block">
                                                                    <div class="position-absolute  bottom-0 end-0">
                                                                        <label for="companylogo-image-input" class="mb-0" data-bs-toggle="tooltip" data-bs-placement="right" title="Select Image">
                                                                            <div class="avatar-xs cursor-pointer">
                                                                                <div class="avatar-title bg-light border rounded-circle text-muted">
                                                                                    <i class="ri-image-fill"></i>
                                                                                </div>
                                                                            </div>
                                                                        </label>
                                                                        <input class="form-control d-none" value="" id="companylogo-image-input" type="file" accept="image/png, image/gif, image/jpeg">
                                                                    </div>
                                                                    <div class="avatar-lg p-1">
                                                                        <div class="avatar-title bg-light rounded-circle">
                                                                            <img src="assets/images/users/multi-user.jpg" id="companylogo-img" class="avatar-md h-auto rounded-circle object-fit-cover" />
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
    
                                                            <div class="mb-3">
                                                                <label for="company-field" class="form-label">Company</label>
                                                                <input type="text" id="company-field" class="form-control" placeholder="Enter company name" required />
                                                            </div>
    
                                                            <div class="mb-3">
                                                                <label for="designation-field" class="form-label">Designation</label>
                                                                <input type="text" id="designation-field" class="form-control" placeholder="Enter designation" required />
                                                            </div>
    
                                                            <div class="mb-3">
                                                                <label for="date-field" class="form-label">Apply Date</label>
                                                                <input type="date" id="date-field" class="form-control" data-provider="flatpickr" data-date-format="d M, Y" required placeholder="Select date" />
                                                            </div>
    
                                                            <div class="mb-3">
                                                                <label for="contact-field" class="form-label">Contacts</label>
                                                                <input type="text" id="contact-field" class="form-control" placeholder="Enter contact" required />
                                                            </div>
    
                                                            <div class="row gy-4 mb-3">
                                                                <div class="col-md-6">
                                                                    <div>
                                                                        <label for="status-input" class="form-label">Status</label>
                                                                        <select class="form-control" data-trigger name="status-input" id="status-input">
                                                                            <option value="">Status</option>
                                                                            <option value="Approved">Approved</option>
                                                                            <option value="New">New</option>
                                                                            <option value="Pending">Pending</option>
                                                                            <option value="Rejected">Rejected</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div>
                                                                        <label for="type-input" class="form-label">Type</label>
                                                                        <select class="form-control" data-trigger name="type-input" id="type-input">
                                                                            <option value="">Select Type</option>
                                                                            <option value="Full Time">Full Time</option>
                                                                            <option value="Part Time">Part Time</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <div class="hstack gap-2 justify-content-end">
                                                                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                                                                <button type="submit" class="btn btn-success" id="add-btn">Add</button>
                                                                <!-- <button type="button" class="btn btn-success" id="edit-btn">Update</button> -->
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Modal -->
                                        <div class="modal fade flip" id="deleteOrder" tabindex="-1" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-body p-5 text-center">
                                                        <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#405189,secondary:#f06548" style="width:90px;height:90px"></lord-icon>
                                                        <div class="mt-4 text-center">
                                                            <h4>You are about to delete a order ?</h4>
                                                            <p class="text-muted fs-15 mb-4">Deleting your order will remove all of your information from our database.</p>
                                                            <div class="hstack gap-2 justify-content-center remove">
                                                                <button class="btn btn-link link-primary fw-semibold text-decoration-none" id="deleteRecord-close" data-bs-dismiss="modal"><i class="ri-close-line me-1 align-middle"></i> Close</button>
                                                                <button class="btn btn-danger" id="delete-record">Yes, Delete It</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!--end modal -->
                                    </div>
                                </div>

                            </div>
                            <!--end col-->
                        </div>
                        <!--end row-->

                    </div>
                    <!-- container-fluid -->
                </div>
                <!-- End Page-content -->

                <?php include 'layouts/footer.php'; ?>
            </div>
            <!-- end main content-->

        </div>
        <!-- END layout-wrapper -->



        <?php include 'layouts/customizer.php'; ?>

        <?php include 'layouts/vendor-scripts.php'; ?>

        <!-- list.js min js -->
        <script src="assets/libs/list.js/list.min.js"></script>

        <!--list pagination js-->
        <script src="assets/libs/list.pagination.js/list.pagination.min.js"></script>

        <!-- ecommerce-order init js -->
        <script src="assets/js/pages/job-application.init.js"></script>

        <!-- Sweet Alerts js -->
        <script src="assets/libs/sweetalert2/sweetalert2.min.js"></script>

        <!-- App js -->
        <script src="assets/js/app.js"></script>

    </body>

</html>